﻿namespace U2UConsult.SQL.TransactionIsolationLevel.Sample
{
 using System;
 using System.Data;
 using System.Data.SqlClient;

 /// <summary>
 /// Transaction Isolation Level.
 /// </summary>
 public class TransactionIsolationLevel : IDisposable
 {
  /// <summary>
  /// The database connection.
  /// </summary>
  private IDbConnection connection;

  /// <summary>
  /// Original isolation level of the connection.
  /// </summary>
  private IsolationLevel originalIsolationLevel;

  /// <summary>
  /// Initializes a new instance of the TransactionIsolationLevel class.
  /// </summary>
  /// <param name="connection">Database connection.</param>
  /// <param name="isolationLevel">Required isolation level.</param>
  public TransactionIsolationLevel(IDbConnection connection, IsolationLevel isolationLevel)
  {
   this.connection = connection;
   this.originalIsolationLevel = this.connection.GetIsolationLevel();
   this.connection.SetIsolationLevel(isolationLevel);
  }

  /// <summary>
  /// Resets the isolation level back to the original value.
  /// </summary>
  public void Dispose()
  {
   this.connection.SetIsolationLevel(this.originalIsolationLevel);
  }
 }
}
